﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;
using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class CardPanel : UserControl
    {
        public CardPanel()
        {
            InitializeComponent();
        }

        #region Public Methods

        public void MyStatusChangedEventHandler(object sender, StatusUpdateEventArgs args)
        {
            // Update view(s)
            UpdatePortStateLabel(Program.Controller.Reader.PortState);
        }

        public void SetVisible(bool _visible)
        {
            Visible = _visible;
        }

        #endregion

        #region Private Methods

        private void UpdatePortStateLabel(PortState _state)
        {
            switch (_state)
            {
                case PortState.Closed:
                    this.UIThread(() => this.portStateLabel.Text = "COM PORT NOT OPEN");
                    break;

                case PortState.Open:
                    this.UIThread(() => this.portStateLabel.Text = "NOT CONNECTED");
                    break;

                case PortState.Connected:
                    this.UIThread(() => this.portStateLabel.Text = "CONNECTED");
                    break;
            }
        }

        #endregion

        #region Event Handling

        // Handler for exit button click
        private void exitButton_Click(object sender, EventArgs e)
        {
            // Terminate all event loops and return control to Program.cs
            Application.Exit();
        }

        // Handler for Mifare button click
        private void mifareButton_Click(object sender, EventArgs e)
        {
            // Ignore clicks if not connected to a reader
            if (Program.Controller.Reader.PortState == PortState.Connected)
            {
                // Program reader
                if (Program.Controller.Reader.SetMode(Mode.MIFARE))
                {
                    // Select view
                    Program.Controller.SelectDataViewPanel(ViewMode.CARD, true);
                }
            }
        }

        private void icodeButton_Click(object sender, EventArgs e)
        {
            // Ignore clicks if not connected to a reader
            if (Program.Controller.Reader.PortState == PortState.Connected)
            {
                // Program reader
                if (Program.Controller.Reader.SetMode(Mode.ICODE))
                {
                    // Select view
                    Program.Controller.SelectDataViewPanel(ViewMode.CARD, true);
                }
            }
        }

        private void CardPanel_Load(object sender, EventArgs e)
        {
            // Register for status update events unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                Program.Controller.Reader.StatusUpdateEvent += MyStatusChangedEventHandler;
            }
        }

        #endregion
    }
}
